/*
   This program creates two child processes and then builds
   a two stage pipeline out of those two processes. This
   parent process is not part of the pipeline. It does not
   share in any of the work done in the pipeline.

   To build the pipeline, the parent starts each of the child
   processes, then it makes the first child inherit the parent's
   stdin, then it makes the second child inherit the parent's
   stdout, then it redirects the first child's stdout to the
   second child's stdin. The parent should end up sharing stdin
   with the first child and stdout with the second child, but
   the parent should make no use of stdin and stdout while its
   children are running.


   Important: Notice that this program is logically
   the same as the following command line pipe.

   C:\> java RemoveVowels | java ToUpperCase

   In the case of the above command line, the shell
   program (cmd.exe) sets up the pipeline before running
   the two programs RemoveVowels.class and ToUpperCase.class.
   In the case of this program, the program itself creates
   the pipeline between the two child processes. So this
   program is acting like a very simple shell program.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_Pipeline_ver2
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the stage1 child.
      String cmd1 = "java RemoveVowels";
           //cmd1 = "java RemoveVowelsDelayed";  // or use this "delayed" version of the filter
      // Execute the first filter.
      Process process1 = Runtime.getRuntime().exec(cmd1);

      // Create a command line for running the stage2 child.
      String cmd2 = "java ToUpperCase";
           //cmd2 = "java ToUpperCaseDelayed";   // or use this "delayed" version of the filter
      // Execute the second filter.
      Process process2 = Runtime.getRuntime().exec(cmd2);


      // Get references to the streams for sending input into each stage.
      PrintStream stage1In = new PrintStream( process1.getOutputStream() );
      PrintStream stage2In = new PrintStream( process2.getOutputStream() );

      // Get references to the streams for reading output from each stage.
      Scanner stage1Out = new Scanner( process1.getInputStream() );
      Scanner stage2Out = new Scanner( process2.getInputStream() );


      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {  // Send one line from stdin to the first stage of the pipeline.
         String oneLine1 = scanner.nextLine();  // read from stdin
         stage1In.println( oneLine1 );          // write to first stage
         stage1In.flush();                      // THIS IS IMPORTANT (without it process2 hangs)

         // Get one line out of the first stage and send it to the second stage.
         String oneLine2 = stage1Out.nextLine(); // read from first stage
         stage2In.println( oneLine2 );           // write to second stage
         stage2In.flush();                       // THIS IS IMPORTANT (without it the parent hangs)

         // Get one line out of the second stage and send it to stdout
         String oneLine3 = stage2Out.nextLine();
         System.out.println( oneLine3 );
      }
      stage1In.close();  // let the first child know that it can terminate
      stage2In.close();  // let the second child know that it can terminate

      // Wait for the second child to finish its work.
      process2.waitFor();  // this throws InterruptedException
   }
}